# College Symposium Events Management Admin Panel

## Table of Contents

1. [Introduction](#introduction)
2. [Features](#features)
3. [Tech Stack](#tech-stack)
4. [Installation and Deployment](#installation-and-deployment)
5. [Contribution](#contribution)
6. [Output Video](#output-video)
7. [Contact](#get-in-touch)

---

### Introduction

This admin panel website serves as a comprehensive management system for organizing college symposium events. Built using PHP and MySQL, it boasts a responsive design catering to both mobile and desktop users. Admins gain efficient control over user management, participant oversight, and handling event feedback and queries, ensuring streamlined event operations.

### Features

- **User Management**: Efficiently manage user accounts, permissions, and roles within the system.
- **Participant Oversight**: Monitor and manage participants' details, registrations, and participation statuses.
- **Event Feedback and Queries**: Handle feedback, queries, and communication related to events effectively.
- **Responsive Design**: Ensures seamless usability across various devices, including mobiles and desktops.
- **Admin Authentication**: Secure login system providing access only to authorized administrators.

### Tech Stack

- **Frontend**: HTML, CSS (Bootstrap for responsive design)
- **Backend**: PHP
- **Database**: MySQL

### Installation and Deployment

#### Steps for Installation:

1. Clone the repository: `git clone https://github.com/vijaisuria/admin-panel-event-management.git`
2. Set up the MySQL database by importing <kbd>enigma_db.sql</kbd> located in <kbd>database</kbd> folder.
3. Configure the database connection in the PHP files.
4. Host the website on a PHP-enabled server (i.e. XAMPP, Apache).

#### Deployment:

- Ensure PHP and MySQL are properly installed and configured on the server.
- Upload the website files to the server.
- Set necessary file permissions and server configurations.

### Contribution

Contributions to this project are welcome! Feel free to fork the repository, make changes, and submit a pull request.

### Screenshots

![Login page](https://raw.githubusercontent.com/vijaisuria/admin-panel-event-management/master/output/screenshot-1.png).
![Admin Dashboard](https://raw.githubusercontent.com/vijaisuria/admin-panel-event-management/master/output/screenshot-2.png)
![User controller](https://raw.githubusercontent.com/vijaisuria/admin-panel-event-management/master/output/screenshot-3.png)
![Participants controller](https://raw.githubusercontent.com/vijaisuria/admin-panel-event-management/master/output/screenshot-4.png)

### Output Video

Include a link to the video demonstrating the admin panel's functionalities here.

[Output Video Link](https://annauniv0-my.sharepoint.com/:v:/g/personal/2021503568_student_annauniv_edu/ETVHnivhoxhMiwbIMEJf87EBDp5ow5hh08Sbmb4HZ4osFA?nav=eyJyZWZlcnJhbEluZm8iOnsicmVmZXJyYWxBcHAiOiJPbmVEcml2ZUZvckJ1c2luZXNzIiwicmVmZXJyYWxBcHBQbGF0Zm9ybSI6IldlYiIsInJlZmVycmFsTW9kZSI6InZpZXciLCJyZWZlcnJhbFZpZXciOiJNeUZpbGVzTGlua0NvcHkifX0&e=P7befp)

## Get in Touch

For inquiries or collaborations, connect with me through 📬:

- Email: [vijaisuria87@gmail.com](mailto:vijaisuria87@gmail.com)
- LinkedIn: [vijaisuria](https://www.linkedin.com/in/vijaisuria/)
- Twitter: [vijaisuria](https://twitter.com/vijaisuria)
- GitHub: [Vijai Suria](https://github.com/vijaisuria)

